local assets=
{ 
    Asset("ANIM", "anim/wand_i.zip"),
	Asset("ANIM", "anim/swap_wand_i.zip"),
    Asset("ATLAS", "images/inventoryimages/wand_i.xml"),
	Asset("IMAGE", "images/inventoryimages/wand_i.tex"),
}

-- local dam = 120

local prefabs =
{
	"nato556",
	"m203",
	"explode_small",
}

local function onattack_fs2000(inst, owner, target)
	if owner.components.inventory:Has("nato556", 1) or owner:HasTag("ai") then
	inst.SoundEmitter:PlaySound("shots/gunshot/fs2000shot")
	else if owner.components.inventory:Has("m203", 1) then
	inst.SoundEmitter:PlaySound("shots/gunshot/bulldog6shot")	
	
	end
	
	end
end

local function OnEquip(inst, owner) 
        owner.AnimState:OverrideSymbol("swap_object", "swap_wand_i", "wand")
        owner.AnimState:Show("ARM_carry") 
        owner.AnimState:Hide("ARM_normal") 
end

local function OnUnequip(inst, owner) 
        owner.AnimState:Hide("ARM_carry") 
        owner.AnimState:Show("ARM_normal") 
end



local function fn(colour)

	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter() 
    ---- 
    MakeInventoryPhysics(inst)
    
	
    anim:SetBank("wand")
    anim:SetBuild("wand_i")
    anim:PlayAnimation("idle")

	inst:AddComponent("weapon")
	inst.components.weapon:SetDamage(0)
    inst.components.weapon:SetRange(19)
    inst.components.weapon:SetOnAttack(onattack_fs2000)
    inst.components.weapon:SetProjectile("nato556")
		
	inst:AddComponent("inspectable")
		
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "wand_i"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/wand_i.xml"
    
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( OnEquip )
    inst.components.equippable:SetOnUnequip( OnUnequip )
	
	inst.HasAmmo = function(inst, owner)
		if (owner and owner.components.inventory and owner.components.inventory:Has("nato556", 1))or (owner:HasTag("ai"))		then
			owner.components.inventory:ConsumeByName("nato556", 1)
	inst.components.weapon:SetProjectile("nato556")
	inst.components.weapon:SetDamage(61)
			return true		
		else if(owner and owner.components.inventory and owner.components.inventory:Has("m203", 1))	then
		owner.components.inventory:ConsumeByName("m203", 1)
	inst.components.weapon:SetProjectile("m203")
	inst.components.weapon:SetDamage(143)
		return true
		end
		return false
	end
	end
	
	
	-- inst.HasAmmo = function(inst, owner)
		-- if (owner and owner.components.inventory and owner.components.inventory:Has("nato556", 1)) or (owner:HasTag("ai")) then
			-- return true
		-- end
		-- return false
	-- end
	
    return inst
end

return  Prefab("common/inventory/wand_i", fn, assets)